/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui;

import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.ac;
import com.webcodepro.applecommander.util.TextBundle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AppleCommander {
    public static final String VERSION;
    private static TextBundle textBundle;

    public static void main(String[] args) {
        if (args.length == 0) {
            if (AppleCommander.isSwtAvailable()) {
                AppleCommander.launchSwtAppleCommander(args);
            } else if (AppleCommander.isSwingAvailable()) {
                AppleCommander.launchSwingAppleCommander(args);
            } else {
                AppleCommander.showHelp();
            }
        } else {
            String[] extraArgs = new String[args.length - 1];
            System.arraycopy(args, 1, extraArgs, 0, extraArgs.length);
            if ("-swt".equalsIgnoreCase(args[0])) {
                if (AppleCommander.isSwtAvailable()) {
                    AppleCommander.launchSwtAppleCommander(args);
                } else {
                    System.err.println(textBundle.get("SwtVersionNotAvailable"));
                }
            } else if ("-swing".equalsIgnoreCase(args[0])) {
                if (AppleCommander.isSwingAvailable()) {
                    AppleCommander.launchSwingAppleCommander(args);
                } else {
                    System.err.println(textBundle.get("SwingVersionNotAvailable"));
                }
            } else if ("-command".equalsIgnoreCase(args[0])) {
                System.err.println(textBundle.get("CommandLineNotAvailable"));
            } else if ("-help".equalsIgnoreCase(args[0]) || "-?".equalsIgnoreCase(args[0])) {
                AppleCommander.showHelp();
            } else {
                ac.main(args);
            }
        }
    }

    protected static void launchSwtAppleCommander(String[] args) {
        try {
            Class<?> swtAppleCommander = Class.forName("com.webcodepro.applecommander.ui.swt.SwtAppleCommander");
            Object object = swtAppleCommander.newInstance();
            Method launchMethod = swtAppleCommander.getMethod("launch", null);
            launchMethod.invoke(object, (Object[])null);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    protected static boolean isSwtAvailable() {
        try {
            Class.forName("org.eclipse.swt.SWT");
            Class.forName("com.webcodepro.applecommander.ui.swt.SwtAppleCommander");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    protected static boolean isSwingAvailable() {
        try {
            Class.forName("com.webcodepro.applecommander.ui.swing.SwingAppleCommander");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    protected static void launchSwingAppleCommander(String[] args) {
        try {
            Class<?> swingAppleCommander = Class.forName("com.webcodepro.applecommander.ui.swing.SwingAppleCommander");
            Object object = swingAppleCommander.newInstance();
            Method launchMethod = swingAppleCommander.getMethod("launch", null);
            launchMethod.invoke(object, (Object[])null);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    protected static void showHelp() {
        System.err.println(textBundle.get("AppleCommanderHelp"));
        System.err.println();
        ac.help();
    }

    static {
        textBundle = UiBundle.getInstance();
        VERSION = AppleCommander.class.getPackage().getImplementationVersion();
    }
}

